enum
{
	ZP_LEVEL_ITEM_AVAILIBLE = 0, // These are return values that can be used in zp_level_item_selected_pre forward
	ZP_LEVEL_ITEM_NOT_AVAILIBLE, // if you want the item to be visible but the player cant get it use this one
	ZP_LEVEL_ITEM_DONT_SHOW	// if you want the item not to be visible for the player use this one
}

/*
* Called before the Player Purchases
* @param id 		Player's index
* @param iItem 		Item's index
* @return 			Returns from above
*/
forward zp_level_item_selected_pre(id, iItem);

/*
* Called when the Player Purchases
* @param id 		Player's index
* @param iItem 		Item's index
* @return 			Return ZP_PLUGIN_HANDLED if you dont want to drain the player's ammo packs if the item has a cost
*/
forward zp_level_item_selected_post(id, iItem);

/*
* @param id 		Player's index
* @return 			Player's Level if success otherwise -1 for failure
*/

native zp_get_user_level(id);

/*
* @param id 		Player's index
* @return 			Player's Exp if success otherwise -1 for failure
*/

native zp_get_user_exp(id);

/*
* @param id 		Player's index
* @return 			Ammount of Exp Required to reach the next level if success otherwise -1 for failure
*/

native zp_next_user_level_exp(id);

/*
* @param szName		New Level Item's Name
* @param iLevel		Level Required to get the item
* @param iTeam		Use ZP_TEAM_HUMAN if you want the item to be visible only for humans, ZP_TEAM_ZOMBIE for Zombies and ZP_TEAM_ALL for Both
* @param iCoust		Optional if you want the item to be purshased by a certain ammount of ammo packs
* @return			Item's Index
*
*/

native zp_register_level_item(const szName[], iLevel, iTeam, iCost = 0);


native zp_next_level_exp(id)

native zp_give_user_exp(id)

native zp_set_user_exp(id, amount)

native zp_set_user_level(id, amount)

stock zp_level_printcolor(const id, const input[], any:...)  
{  
	new count = 1, players[32];  
	static msg[191];  
	vformat(msg, 190, input, 3);  

	replace_all(msg, 190, "!g", "^x04"); // Green Color  
	replace_all(msg, 190, "!y", "^x01"); // Default Color  
	replace_all(msg, 190, "!t", "^x03"); // Team Color  

	if (id) players[0] = id; else get_players(players, count, "ch");  
	{  
		for (new i = 0; i < count; i++)  
		{  
			if (is_user_connected(players[i]))  
			{  
				message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, players[i]);  
				write_byte(players[i]);  
				write_string(msg);  
				message_end();  
			}  
		}  
	}  
} 

