/* Returns the users amount of points */
native ps_get_user_points(id);

/* Set the users amount of points
*  If you add points: Status = 1
*  If you subtract points: Status = 0 */
native ps_set_user_points(id, amount, status, sound = 0);

/* Returns the users specified status */
native ps_get_user_status(id, status);

/* Set the users specified status */
native ps_set_user_status(id, status, value, sound = 0);

/* Status Values */
enum
{
	NON, /* 0 = Dummy		*/

	VIP, /* 1 = VIP Votekick	*/
	CPM, /* 2 = Custom PM TE	*/
	MRS, /* 3 = Mute Rights		*/
	VRS, /* 4 = VIP Mute Rights	*/
	MTD, /* 5 = Muted		*/
	CPT  /* 6 = Custom PM CT	*/
};

/* Returns true if the user is banned */
native ps_get_user_banned(id);

/* Change the users access status: 0 = Unbanned || 1 = Banned */
native ps_set_user_banned(id, access);

/* Returns the users rank */
//native ps_get_point_rank(points, string[], len);

/* Returns the average amount of points */
//native ps_get_average_points();

/* Returns true if the user has Double Jump */
native ps_get_user_dj(id);

/* Returns true if the user has Damage Multiplier */
native ps_get_user_dm(id);

/* Returns true if the user is a Chameleon */
native ps_get_user_cm(id);

/* Returns true if the user has a Custom Player Model */
native ps_get_user_cpm(id);

/* Returns true if the user is muted */
native ps_get_user_muted(id);

/*
* team: 1 = Terrorist || 2 = Counter-Terrorist
*/

/* Returns the amount of models loaded specified by team */
*  Default = 0: Total amount of models loaded
*  Returns -1 on failure */
native ps_get_models_loaded(team = 0);

/* Returns the users model number for the specified team */
native ps_get_model_num(const model_file[], team);

/* Returns the models name by number and team */
native ps_get_model_name(num, model_name[], len, team);

/* Returns the models file by model name and team */
native ps_get_model_file(const model_name[], file[], len, team);

/* Point System Print - Chat */
native ps_print(id, text[], any:...);

/* Point System Print - Log || Debug Mode has to be enabled */
native ps_log(text[], any:...);

/* Add Custom Menu Option to the point system menu
*  Specify a unique_id to update the menu later
*  Use with "ps_user_menu_creation" forward */
native ps_add_menu_item(const text[], unique_id);

/* Update a already added Custom Menu Option by unique id
*  Returns: 1 = [success] || 0 = [no custom menus] || -1 = [unique id not found] */
native ps_update_menu_item(unique_id, const text[]);

/* Remove a created Custom Menu Option by unique id
*  Returns: 1 = [success] || 0 = [no custom menus] || -1 = [unique id not found]*/
native ps_remove_menu_item(unique_id);

/*********************** [ FORWARDS ] ***********************/

/* Called when the '/ps' menu is called (pre) */
forward ps_user_menu_creation(id);

/* Called when a user chooses a menu option (pre) */
forward ps_user_menu_selection(id, option);

/* Option Values */
enum
{
	OTH,	/* 0 = No Match		*/

	SPS,	/* 1 = Show Points	*/
	DBJ,	/* 2 = Double Jump	*/
	VVK,	/* 3 = VIP VoteKick	*/
	CPL,	/* 4 = Custom Model	*/
	MER,	/* 5 = Mute Rights	*/
	VME,	/* 6 = VIP Mute Rights	*/
	SAM,	/* 7 = Start a Mapvote	*/
	CHM,	/* 8 = Chameleon	*/
	MPD	/* 9 = Multi Damage	*/
};

/* Called when a user receives points
*  Status = 1: Positive addition of points
*  Status = 0: Negative subtraction of points */
forward ps_user_points_pre(id, points, status);
forward ps_user_points_post(id, points, status);

/* Called when a users status is changed
*  Check "Status Values" above for values */
forward ps_user_status_pre(id, status, value);
forward ps_user_status_post(id, status, value);

/* Called when a users access status is changed
*  Status Values: 0 = UnBanned || 1 = Banned */
//forward ps_user_banned_pre(id, status);
//forward ps_user_banned_post(id, status);