#if defined _crypto_included
  #endinput
#endif
#define _crypto_included

/*
BASE64: http://www.opensource.apple.com/source/QuickTimeStreamingServer/QuickTimeStreamingServer-452/CommonUtilitiesLib/base64.c
SHA1: https://github.com/emn178/js-sha1 / https://github.com/emn178/js-sha512

INC by Destro (https://amxmodx-es.com) and sha1 function modified (raw instead of hex) by LuKks
*/

stock const gSHA_HEXCHAR[] = "0123456789abcdef"
stock const gSHA_EXTRA[] = { -2147483648, 8388608, 32768, 128 }
stock const gSHA_SHIFT[] = { 24, 16, 8, 0 }

stock SHA1_Data(const data[], size, out[]) {
	new h0, h1, h2, h3, h4, block, blocks[160], code, end, t, f, i, j, index, start, bytes;

	h0 = 0x67452301;
	h1 = 0xEFCDAB89;
	h2 = 0x98BADCFE;
	h3 = 0x10325476;
	h4 = 0xC3D2E1F0;

	do {
		blocks[0] = block;
		blocks[16] = blocks[1] = blocks[2] = blocks[3] =
		blocks[4] = blocks[5] = blocks[6] = blocks[7] =
		blocks[8] = blocks[9] = blocks[10] = blocks[11] =
		blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
	
		for (i = start;index < size && i < 64; ++index) {
			code = data[index];
			
			if(code < 0) code = 256 + code
			
			blocks[i >> 2] |= code << gSHA_SHIFT[i++ & 3];
		}

		bytes += i - start;
		start = i - 64;
		
		if(index == size) {
			blocks[i >> 2] |= gSHA_EXTRA[i & 3];
			++index;
		}
		
		block = blocks[16];
		if(index > size && i < 56) {
			blocks[15] = bytes << 3;
			end = true;
		}

		for(j = 16;j < 80;++j) {
			t = blocks[j - 3] ^ blocks[j - 8] ^ blocks[j - 14] ^ blocks[j - 16];
			blocks[j] =  (t << 1) | (t >>> 31);
		}

		new a = h0, b = h1, c = h2, d = h3, e = h4;
		for(j = 0;j < 20;j += 5) {
			f = (b & c) | ((~b) & d);
			t = (a << 5) | (a >>> 27);
			e = t + f + e + 1518500249 + blocks[j] << 0;
			b = (b << 30) | (b >>> 2);

			f = (a & b) | ((~a) & c);
			t = (e << 5) | (e >>> 27);
			d = t + f + d + 1518500249 + blocks[j + 1] << 0;
			a = (a << 30) | (a >>> 2);

			f = (e & a) | ((~e) & b);
			t = (d << 5) | (d >>> 27);
			c = t + f + c + 1518500249 + blocks[j + 2] << 0;
			e = (e << 30) | (e >>> 2);

			f = (d & e) | ((~d) & a);
			t = (c << 5) | (c >>> 27);
			b = t + f + b + 1518500249 + blocks[j + 3] << 0;
			d = (d << 30) | (d >>> 2);

			f = (c & d) | ((~c) & e);
			t = (b << 5) | (b >>> 27);
			a = t + f + a + 1518500249 + blocks[j + 4] << 0;
			c = (c << 30) | (c >>> 2);
		}

		for(;j < 40;j += 5) {
			f = b ^ c ^ d;
			t = (a << 5) | (a >>> 27);
			e = t + f + e + 1859775393 + blocks[j] << 0;
			b = (b << 30) | (b >>> 2);

			f = a ^ b ^ c;
			t = (e << 5) | (e >>> 27);
			d = t + f + d + 1859775393 + blocks[j + 1] << 0;
			a = (a << 30) | (a >>> 2);

			f = e ^ a ^ b;
			t = (d << 5) | (d >>> 27);
			c = t + f + c + 1859775393 + blocks[j + 2] << 0;
			e = (e << 30) | (e >>> 2);

			f = d ^ e ^ a;
			t = (c << 5) | (c >>> 27);
			b = t + f + b + 1859775393 + blocks[j + 3] << 0;
			d = (d << 30) | (d >>> 2);

			f = c ^ d ^ e;
			t = (b << 5) | (b >>> 27);
			a = t + f + a + 1859775393 + blocks[j + 4] << 0;
			c = (c << 30) | (c >>> 2);
		}

		for(;j < 60;j += 5) {
			f = (b & c) | (b & d) | (c & d);
			t = (a << 5) | (a >>> 27);
			e = t + f + e - 1894007588 + blocks[j] << 0;
			b = (b << 30) | (b >>> 2);

			f = (a & b) | (a & c) | (b & c);
			t = (e << 5) | (e >>> 27);
			d = t + f + d - 1894007588 + blocks[j + 1] << 0;
			a = (a << 30) | (a >>> 2);

			f = (e & a) | (e & b) | (a & b);
			t = (d << 5) | (d >>> 27);
			c = t + f + c - 1894007588 + blocks[j + 2] << 0;
			e = (e << 30) | (e >>> 2);

			f = (d & e) | (d & a) | (e & a);
			t = (c << 5) | (c >>> 27);
			b = t + f + b - 1894007588 + blocks[j + 3] << 0;
			d = (d << 30) | (d >>> 2);

			f = (c & d) | (c & e) | (d & e);
			t = (b << 5) | (b >>> 27);
			a = t + f + a - 1894007588 + blocks[j + 4] << 0;
			c = (c << 30) | (c >>> 2);
		}

		for(;j < 80;j += 5) {
			f = b ^ c ^ d;
			t = (a << 5) | (a >>> 27);
			e = t + f + e - 899497514 + blocks[j] << 0;
			b = (b << 30) | (b >>> 2);

			f = a ^ b ^ c;
			t = (e << 5) | (e >>> 27);
			d = t + f + d - 899497514 + blocks[j + 1] << 0;
			a = (a << 30) | (a >>> 2);

			f = e ^ a ^ b;
			t = (d << 5) | (d >>> 27);
			c = t + f + c - 899497514 + blocks[j + 2] << 0;
			e = (e << 30) | (e >>> 2);

			f = d ^ e ^ a;
			t = (c << 5) | (c >>> 27);
			b = t + f + b - 899497514 + blocks[j + 3] << 0;
			d = (d << 30) | (d >>> 2);

			f = c ^ d ^ e;
			t = (b << 5) | (b >>> 27);
			a = t + f + a - 899497514 + blocks[j + 4] << 0;
			c = (c << 30) | (c >>> 2);
		}

		h0 = h0 + a << 0;
		h1 = h1 + b << 0;
		h2 = h2 + c << 0;
		h3 = h3 + d << 0;
		h4 = h4 + e << 0;
	} while(!end);

	out[0] = h0 >> 24;
	out[1] = h0 >> 16;
	out[2] = h0 >> 8;
	out[3] = h0;

	out[4] = h1 >> 24;
	out[5] = h1 >> 16;
	out[6] = h1 >> 8;
	out[7] = h1;

	out[8] = h2 >> 24;
	out[9] = h2 >> 16;
	out[10] = h2 >> 8;
	out[11] = h2;

	out[12] = h3 >> 24;
	out[13] = h3 >> 16;
	out[14] = h3 >> 8;
	out[15] = h3;

	out[16] = h4 >> 24;
	out[17] = h4 >> 16;
	out[18] = h4 >> 8;
	out[19] = h4;

	return true;
}

stock const gBase64_Fill = '='
stock const gBase64_Table[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
stock const gDecode_Table[256] = {
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64,
	64,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64,
	64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
	64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64
};

stock BASE64_Encode(const data[], size=0, output[], len) {
	new write, i
	if(!size) size = strlen(data)
 
	for(i = 0; i < (size - 2); i += 3)
	{
		if((write + 4) >= len)
		{
			output[0] = '^0';
			return 0;
		}
	
		output[write++] = gBase64_Table[(data[i] >> 2) & 0x3F];
		output[write++] = gBase64_Table[((data[i] & 0x3) << 4) | ((data[i + 1] & 0xF0) >> 4)];
		output[write++] = gBase64_Table[((data[i + 1] & 0xF) << 2) | ((data[i + 2] & 0xC0) >> 6)];
		output[write++] = gBase64_Table[data[i + 2] & 0x3F];
	}
	
	if(i < size)
	{
		if((write + 4) >= len)
		{
			output[0] = '^0';
			return 0;
		}
	
		output[write++] = gBase64_Table[(data[i] >> 2) & 0x3F];
		
		if(i == (size - 1))
		{
			output[write++] = gBase64_Table[((data[i] & 0x3) << 4)];
			output[write++] = gBase64_Fill;
		}
		else
		{
			output[write++] = gBase64_Table[((data[i] & 0x3) << 4) | ((data[i + 1] & 0xF0) >> 4)];
			output[write++] = gBase64_Table[((data[i + 1] & 0xF) << 2)];
		}
		
		output[write++] = gBase64_Fill;
	}

	output[write] = '^0';
	return write;
}
